<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}


$routes->get('dashboard', 'DashboardController::index');
$routes->get('video', 'VideoController::index');
$routes->get('add_video', 'VideoController::add');
$routes->post('add_video', 'VideoController::add');
$routes->post('videolistajaxDatatables', 'VideoController::videolistajaxDatatables');
$routes->get('edit-video/(:hash)', 'VideoController::edit/$1');
$routes->post('edit-video/(:hash)', 'VideoController::edit/$1');
$routes->get('delete-video/(:hash)', 'VideoController::delete/$1');

$routes->get('category', 'CategoryController::index');

$routes->get('addcategory', 'CategoryController::add');
$routes->post('addcategory', 'CategoryController::add');
$routes->post('listajaxDatatables', 'CategoryController::listajaxDatatables');


$routes->get('editcategory/(:hash)', 'CategoryController::edit/$1');
$routes->post('editcategory/(:hash)', 'CategoryController::edit/$1');

$routes->get('deletecategory/(:hash)', 'CategoryController::delete/$1');


// sub category
$routes->get('subcategory', 'SubcategoryController::index');

$routes->get('addsubcategory', 'SubcategoryController::add');
$routes->post('addsubcategory', 'SubcategoryController::add');
$routes->post('sublistajaxDatatables', 'SubcategoryController::listajaxDatatables');


$routes->get('editsubcategory/(:hash)', 'SubcategoryController::edit/$1');
$routes->post('editsubcategory/(:hash)', 'SubcategoryController::edit/$1');

$routes->get('deletesubcategory/(:hash)', 'SubcategoryController::delete/$1');